package client;

import java.util.Hashtable;

/**
 * Table of all response posibilities.
 * @author Eric
 */
public class ClientResponseTable {

	/**
	 * Sets up response table.
	 */
	public static void init() {
		responseTable = new Hashtable();
		
		// First var is an int (0...65535)
		// Second var is a class name.
		try {
			// Core
			add( Constants.RESP_AUTH_OK, 		"ClientResponseAuthOK" ); 
			add( Constants.RESP_AUTH_REJECTED, 	"ClientResponseAuthRejected" );
			add( Constants.RESP_DISCONNECTED, 	"ClientResponseDisconnected" );
			add( Constants.RESP_GLOBAL_UPDATE, 	"ClientResponseGlobalUpdate" );
			add( Constants.RESP_BUDDYLIST, 		"ClientResponseBuddyList" );
			
			add( Constants.RESP_LOGIN, 			"ClientResponseLogin" );
			add( Constants.RESP_LOGOUT, 		"ClientResponseLogout" );
			add( Constants.RESP_MOTION, 		"ClientResponseMotion" );
			
			add( Constants.RESP_CHAT_GLOBAL, 	"ClientResponseChatGlobal" );
			
			
			// SpaceGame.
			add( Constants.RESP_QUESTION_DOUBLE,	"ClientResponseQuestionDouble" );
			add( Constants.RESP_QUESTION_INT,		"ClientResponseQuestionInt" );
			add( Constants.RESP_QUESTION_STRING,	"ClientResponseQuestionString" );
			add( Constants.RESP_QUESTION_CHOICE,	"ClientResponseQuestionChoice" );
			add( Constants.RESP_ANSWER_CHECK,	    "ClientResponseAnswerCheck" );
		} catch (ClassNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	
	/**
	 * Adds a game response
	 * @param c first int value 0..65535 of the response
	 * @param name the ClientResponse child class
	 * @throws ClassNotFoundException 
	 */
	private static void add( int c, String name ) throws ClassNotFoundException {
//		Class resp = Class.forName( "client.response." + name );
//		responseTable.put( new Integer( c ), resp );
		responseTable.put( new Integer( c ), name );
	}
	
	/** 
	 * Gets the name of the class corresponding with 
	 * a ClientResponse
	 * 
	 * @param ClientResponse name
	 * @return class name
	 * @throws IllegalAccessException 
	 * @throws InstantiationException 
	 * @throws ClassNotFoundException 
	 */
	public static client.response.ClientResponse get( int id ) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
		//return (client.response.ClientResponse) responseTable.get( new Integer( responseID ) ).getClass().newInstance();
		String name = (String) responseTable.get( new Integer( id ) );
		return (client.response.ClientResponse) (Class.forName( "client.response." + name ) ).newInstance();
	}
	
	/**
	 * Mapping of names of requests to corresponding class name.
	 */
	private static Hashtable responseTable;

}
