package client;

import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.m3g.Transform;


/**
 * Handles input for the game client.
 * @author Eric
 */
public class GameInput extends Thread {
	
	// Game object.
	private Game canvas;
	
	// Client user.
	private User user = null;
	
	private boolean active = true;
	
	/**
	 * Instantiates class and gets pointer to
	 * the game object.
	 * @param canvas
	 */
	public GameInput( Game canvas ) {
		super();
		this.canvas = canvas;
		user = canvas.getClient().getMyUser();
	}
	
	/**
	 * Turns the timer on.
	 */
	public void activate() {
		active = true;
	}
	
	/**
	 * Gently turns the timer off.
	 * YOU MUST CALL THIS BEFORE CANCEL()!!!
	 */
	public void deactivate() {
		active = false;
	}
		
	
	/**
	 * Checks for input and sends the results to
	 * the game object.
	 * 
	 * Called by run().
	 */
	private void doInput() {
		boolean updated = false;		
		int keys = canvas.getKeyStates();
		
		// Up.
		if ( (keys & GameCanvas.UP_PRESSED)    != 0 ) {
			if ( user.getForwardSpeed() != -canvas.getClientSpeed() ) {
				updated = true;
				user.setForwardSpeed( -canvas.getClientSpeed() );
			}
		} else {
			if ( user.getForwardSpeed() == -canvas.getClientSpeed() ) {
				updated = true;
				user.setForwardSpeed( 0 );
			}
		}
		
		// Down
		if ( (keys & GameCanvas.DOWN_PRESSED)  != 0 ) {
			if ( user.getForwardSpeed() != canvas.getClientSpeed() ) {
				updated = true;
				user.setForwardSpeed( canvas.getClientSpeed() );
			}
		} else {
			if ( user.getForwardSpeed() == canvas.getClientSpeed() ) {
				updated = true;
				user.setForwardSpeed( 0 );
			}
		}
		
		// Left
		if ( (keys & GameCanvas.LEFT_PRESSED ) != 0 ) {
			if ( user.getYAxisAngularVelocity() != canvas.getClientAngularSpeed() ) {
				updated = true;
				user.setYAxisAngularVelocity( canvas.getClientAngularSpeed() );
			}
		} else {
			if ( user.getYAxisAngularVelocity() == canvas.getClientAngularSpeed() ) {
				updated = true;
				user.setYAxisAngularVelocity( 0 );
			}
		}
		
		// Right.
		if ( (keys & GameCanvas.RIGHT_PRESSED ) != 0) {
			if ( user.getYAxisAngularVelocity() != -canvas.getClientAngularSpeed() ) {
				updated = true;
				user.setYAxisAngularVelocity( -canvas.getClientAngularSpeed() );
			}
		} else {
			if ( user.getYAxisAngularVelocity() == -canvas.getClientAngularSpeed() ) {
				updated = true; 
				user.setYAxisAngularVelocity( 0 );
			}
		}
		
		
		// 1 key starts chat mode.
		if ( (keys & GameCanvas.GAME_A_PRESSED ) != 0 ) {
			canvas.showChat();
		}
		
		
		// Remember that we updated.
		if ( updated ) {
			// Set time.
			user.setLastMotionTime( canvas.getClient().currentTime() );
			
			// Copy transform.
			Transform temp = new Transform();
			canvas.gameCam.getTransform( temp );
			user.setTransform( new Transform( temp ) );
			
			// Tell the canvas we need to update.
			canvas.motionUpdate();
		}
	}
	
	/**
	 * Send events to game object.
	 */
	public void run() {
		while ( true ) {
			while ( active ) {
				doInput(); // Process input.
			}
			try {
				Thread.sleep( 100 );
			} catch (InterruptedException e) {
				canvas.getClient().log( e.getMessage() );
			}
		}
	}

}
