package client;

import java.io.IOException;

import client.request.ClientRequestMotion;

public class MotionUpdateThread extends Thread {
	
	// Client user.
	private User user = null;
	
	// Game client
	private MobileGameClient client = null;
	
	// Active var.
	private boolean active = false;
	
	// Set to true when we need to send a motion update.
	private boolean update = false;
	
	
	/**
	 * C'tor preps the thread.
	 * @param client
	 */
	public MotionUpdateThread( MobileGameClient client ) {
		super();
		this.client = client;
		user = client.getMyUser();
	}
	
	/**
	 * Turns the thread on.
	 */
	public void activate() {
		client.log( "Activating MotionUpdateThread" );
		active = true;
	}
	
	/**
	 * Gently turns the thread off.
	 */
	public void deactivate() {
		active = false;
	}
	
	public void update() {
		update = true;
	}
	
	
	public void considerUpdating() {
		if ( update ) {
			// Disable updates (for now)
			update = false;
			
			// Send request.
			client.debug( "Sending RequestMotion" );
			ClientRequestMotion req = new ClientRequestMotion();
			req.setUser( user );
			try {
				client.sendRequest( req );
			} catch ( IOException e ) {
				client.log( "Error sending motion requset." );
				client.log( e.getMessage() );
			}
		}
//		} else {
//			// Send a heartbeat so we stay in sync.
//			client.debug( "Sending heartbeat" );
//			ClientRequestHeartbeat req = new ClientRequestHeartbeat();
//			try {
//				client.sendUpdateRequest( req );
//			} catch ( IOException e ) {
//				client.log( "Error sending heartbeat!" );
//				client.log( e.getMessage() );
//			}
//		}
	}
	
	public void run() {
		while ( true ) {
			while ( active ) {
				considerUpdating();
//				try {
//					Thread.sleep( client.getUpdateSpeed() );
//				} catch (InterruptedException e) {
//					client.log( e.getMessage() );
//				}
			}
			
			try {
				Thread.sleep( 100 );
			} catch (InterruptedException e) {
				client.log( e.getMessage() );
			}
			
		}
		
	}

}
