package client;

import java.util.Vector;

/**
 * Storage class for keeping info about a team.
 * 
 * @author eric
 */
public class Team {
	
	// ID number of team in database.
	private long id;
	
	// Name of team.
	private String name;
	
	// Users who are on this team.
	private Vector members = new Vector();
	
	// Team's color (32-bit RGB)
	private long color;

	/**
	 * Sets the team's id number in the database.
	 * Only the database loading functions should call
	 * this.
	 * @param id
	 */
	public void setId(long id) {
		this.id = id;
	}

	/**
	 * Fetch the team's id number in the database.
	 * @return
	 */
	public long getId() {
		return id;
	}

	/**
	 * Get the team's name.
	 * @param name
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * Change the team's name.
	 * @return
	 */
	public String getName() {
		return name;
	}
	
	/**
	 * Get the team members.
	 * @return vector of all members.
	 */
	public Vector getAllMembers() {
		return members;
	}
	
	/**
	 * Adds a member to the team.
	 * @param u a valid User object.
	 */
	public void addMember( User u ) {
		members.addElement( u );
	}
	
	/**
	 * Removes a member from the team.
	 * @param u a valid User object in this team.
	 */
	public void removeMember( User u ) {
		members.removeElement( u );
	}

	/**
	 * Sets the team's color.
	 * @param color 32-bit RGB color value
	 */
	public void setColor(long color) {
		this.color = color;
	}

	/**
	 * Gets the team's color.
	 * @return
	 */
	public long getColor() {
		return color;
	}
	

}
