package client;


import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;

import javax.microedition.m3g.Mesh;
import javax.microedition.m3g.Transform;

/**
 * Holds information about logged-in players such as
 * their user id, name, team, location, etc. 
 * 
 * @author eric
 *
 */
public class User {
	
	// Name of the character.
	private String name = "";
	
	// User id.
	private long id = -1;
	
	// Transform matrix.
	private Transform transform = new Transform();

	// Float version of transform matrix.
	private float[] matrix = new float[16];
	
	// Motion.
	private float forwardSpeed = 0f;
	private float sidewaysSpeed = 0f;
	private float xAxisAngularVelocity = 0f;
	private float yAxisAngularVelocity = 0f;
	private float zAxisAngularVelocity = 0f;
	
	// When user last issued a motion request.
	private long lastMotionUpdateTime;
	
	// Player model.
	private Mesh model = null;
	
	// Values (points, cash, etc.)
	private Hashtable value = new Hashtable();
	
	// List of update requests for this user.
	Vector updates = new Vector();
	
	// Team, or null if no team.
	private Team team = null;
	
	// When the location and motion vector
	// where last updated.
	private Date motionStartTime = null;
	
	// Local area of user.
	private Sector sector = null; 
	
	// ID of character model.
	private long modelId = 0;
	
	// ID of animation, or 0 if standing still.
	private long animation = 0;
	
	// When the current animation was started.
	private Date animationStartTime = null;
		
	// When the most recent request was sent for
	// this user.  This is used *only* for checking
	// for a timeout.
	private Date lastRequestTime = null;
	

	
	/**
	 * Sets the name.
	 * @param name name of character (username)
	 */
	public void setName( String name ) {
		this.name = name;
	}
	
	/**
	 * Sets the id.
	 * @param name name of character (username)
	 */
	public void setId( long id ) {
		this.id = id;
	}
	
	/**
	 * Gets the ID number of this character.
	 * @return id number, or -1 if invalid.
	 */
	public long getId() {
		return id;
	}
	
	/**
	 * Gets the name of this character.
	 * @return name, or the empty string if invalid.
	 */
	public String getName() {
		return name;
	}
	
	/**
	 * Gets a stored value from this character
	 * @param name name of value
	 * @return value, or -1 if not present.
	 */
	public long getValue( String name ) {
		if ( value.containsKey( name ) ) {
			return ((Long)(value.get( name ))).longValue();
		} else {
			return -1;
		}
	}
	
	/**
	 * Sets a value to a specific number.  BE CAREFUL
	 * with this, setting a value in this way could
	 * result in unpredictable behavior.
	 * 
	 * @param name name of new or existing value
	 * @param newValue the new value to set it to 
	 */
	public void setValue( String name, long newValue ) {
		value.put( name, new Long(newValue) );
	}
	
	/**
	 * Increases a value.  No overflow detection.
	 * 
	 * @param name name of the value
	 * @param amount the amount to increase the value
	 */
	public void increaseValue( String name, long amount ) {
		long v = ((Long)value.get( name )).longValue();
		value.put( name, new Long(v + amount) );
	}
	
	/**
	 * Decreases a value.  No overflow is detected, no
	 * < 0 is checked for.
	 * 
	 * @param name name of the value
	 * @param amount the amount to decrease the value
	 */
	public void decreaseValue( String name, long amount ) {
		long v = ((Long)value.get( name )).longValue();
		value.put( name, new Long( v - amount ) );
	}

	
	/**
	 * Set this user to a given team.
	 * @param team the user's team, or null if no team.
	 */
	public void setTeam( Team team ) {
		this.team = team;
	}

	/**
	 * Fetch this user's team.
	 * @return the user's team, or null if no team.
	 */
	public Team getTeam() {
		return team;
	}


	public void setModelId( long modelID ) {
		this.modelId = modelID;
	}

	public long getModelId() {
		return modelId;
	}
	
	public Sector getSector(){
		return sector;
	}
	
	public void setSector( Sector s ) {
		sector = s;
	}
	
	public void updateAnimation(long animationId) {
		animation = animationId;		
	}
	
	public Date getMoveTime(){
		return motionStartTime;
	}
	
	public Date getAniTime(){
		return animationStartTime;
	}
	
	public void setMoveTime(Date mTime){
		motionStartTime = mTime;
	}
	
	public void setAniTime(Date aTime){
		animationStartTime = aTime;
	}

	public void changeSector(Sector sector) {
		this.sector = sector;		
	}

	public void setLastRequestTime(Date lastRequestTime) {
		this.lastRequestTime = lastRequestTime;
	}

	public Date getLastRequestTime() {
		return lastRequestTime;
	}

//	public void postTranslate( float f, float g, float h ) {
//		transform.postTranslate( f, g, h );
//		
//	}

	/**
	 * Gets translation matrix.
	 * @return
	 */
	public Transform getTransform() {
		return transform;
	}
	
	/**
	 * Sets a transform matrix.
	 * @param t
	 */
	public void setTransform( Transform t ) {
		transform = t;
	}
	
	/**
	 * Sets a transform matrix from an array
	 * @param t float[16] transform matrix
	 */
	public void setTransform( float[] t ) {
		transform.set( t );
	}
	
	public void setForwardSpeed( float forward ) {
		forwardSpeed = forward;
	}
	
	public void setSidewaysSpeed( float sideways ) {
		sidewaysSpeed = sideways;
	}
	
	public float getForwardSpeed() {
		return forwardSpeed;
	}
	
	public float getSidewaysSpeed() {
		return sidewaysSpeed;
	}
	
	/**
	 * Handles a movement "tick" in the game.
	 */
//	public void update() {
//		// TODO: sideways speed
//		transform.postTranslate( 0f, 0f, -forwardSpeed );
//		transform.postRotate( yAxisAngularVelocity, 0f, 1.0f, 0f );
//		// TODO: rotation speed.
//	}

	public float getX() {
		transform.get( matrix );
		return matrix[3];
	}

	public float getY() {
		transform.get( matrix );
		return matrix[7];
	}

	public float getZ() {
		transform.get( matrix );
		return matrix[11];
	}
	
	public float getXAxisAngularVelocity() {
		return xAxisAngularVelocity;
	}
	
	public void setXAxisAngularVelocity( float f ) {
		xAxisAngularVelocity = f;
	}
	
	public float getYAxisAngularVelocity() {
		return yAxisAngularVelocity;
	}
	
	public void setYAxisAngularVelocity( float f ) {
		yAxisAngularVelocity = f;
	}
	
	public float getZAxisAngularVelocity() {
		return zAxisAngularVelocity;
	}
	
	public void setZAxisAngularVelocity( float f ) {
		zAxisAngularVelocity = f;
	}

	/**
	 * Get user's model.
	 * @param model
	 */
	public void setModel( Mesh model ) {
		this.model = model;
	}

	/**
	 * Set user's model.
	 * @return
	 */
	public Mesh getModel() {
		return model;
	}
	
	/**
	 * Remembers when the last motion update happened.
	 * @param updateTime
	 */
	public void setLastMotionTime( long updateTime ) {
		lastMotionUpdateTime = updateTime;
	}
	
	/**
	 * Gets the last time the user's motion was updated, or
	 * -1 if it has not been udpated.
	 * @return
	 */
	public long getLastMotionTime() {
		return lastMotionUpdateTime;
	}


}
