package client.request;

import client.MobileGameClient;

public abstract class ClientRequest implements Runnable {
	
	// Request ID numbers.
	protected final long requestHeartbeat = 0;
	protected final long requestLogin = 1;
	protected final long requestLogout = 2;
	
	protected MobileGameClient client = null;
	
	/**
	 * Must call this before run() with a valid 
	 * MobileGameClient. 
	 * @param client valid game client
	 */
	public void setClient( MobileGameClient client ) {
		this.client = client;
	}
	
	/**
	 * Executes the client request.
	 */
	public abstract void run();

}
