package client.request;

import java.io.IOException;

import client.Constants;

public class ClientRequestAnswerQuestionChoice extends ClientRequest {
	
	private char choice;
	
	/**
	 * The user's selection for the current 
	 * multiple-choice quesiton.
	 * @param choice
	 */
	public void setChoice( char choice ) {
		this.choice = choice;
	}

	public void run() {
		try {
			client.debug("Sending answer...");
			client.getOutputStream().writeInt( Constants.REQ_ANSWER_CHOICE );
			client.getOutputStream().writeLong( client.getUserId() );
			client.getOutputStream().writeChar( choice );
			client.debug("...sent.");			
		} catch (IOException e) {
			e.printStackTrace();
		}

	}

}
