package client.request;

import java.io.IOException;

import client.Constants;

/**
 * Send a chat message to everyone in the game.
 * @author Eric
 */
public class ClientRequestChatGlobal extends ClientRequest {
	
	private long userID = -1;
	
	private String message = null;
	
	public void setUserId( long u ) {
		userID = u;
	}
	
	public void setMessage( String m ) {
		message = m;
	}

	public void run() {
		try {
			client.getOutputStream().writeInt( Constants.RESP_CHAT_GLOBAL );
			client.getOutputStream().writeLong( userID );
			client.getOutputStream().writeUTF( message );
		} catch (IOException e) {
			client.log( e.getMessage() );
		}

	}

}
