package client.request;

import java.io.IOException;

import client.Constants;

/**
 * Sends a username and password to attempt to authenticate
 * the client user.
 * 
 * @author Eric
 */
public class ClientRequestLogin extends ClientRequest {
	
	String username = null;
	
	String password = null;
	
	public void setUsername( String u ) {
		username = u;
	}
	
	public void setPassword( String p ) {
		password = p;
	}

	public void run() {
		try {
			client.getOutputStream().writeInt( Constants.REQ_LOGIN ); // login
			client.getOutputStream().writeUTF( username );
			client.getOutputStream().writeUTF( password );
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

	}

}
