package client.request;

import java.io.IOException;

import client.Constants;

/**
 * Notifies the server that the user wishes to logout.
 * @author Eric
 */
public class ClientRequestLogout extends ClientRequest {

	public void run() {
		try {
			client.debug( "Sending ClientRequestLogout" );
			client.getOutputStream().writeInt( Constants.REQ_LOGOUT );
			client.getOutputStream().writeLong( client.getUserId() );
		} catch (IOException e) {
			client.log( e.getMessage() );
		}

	}

}
