package client.request;

import java.io.IOException;

import javax.microedition.m3g.Transform;

import client.Constants;
import client.User;

/**
 * Change the forward motion velocity of the client.
 * @author Eric
 */
public class ClientRequestMotion extends ClientRequest {
	
	private User user;
	
	public void setUser( User u ) {
		user = u;
	}

	public void run() {
		float[] transform = new float[16];
		Transform t = user.getTransform();
		t.get( transform );
		try {
			client.debug("Sending ClientRequestMotion ");
			client.getOutputStream().writeInt( Constants.REQ_MOTION );
			client.getOutputStream().writeLong( user.getId() );
			
			for( int j = 0; j < transform.length; j++ ) {
				client.getOutputStream().writeFloat( transform[j] );
			}
			
			client.getOutputStream().writeFloat( user.getForwardSpeed() );
			client.getOutputStream().writeFloat( user.getSidewaysSpeed() );
			client.getOutputStream().writeFloat( user.getXAxisAngularVelocity() );
			client.getOutputStream().writeFloat( user.getYAxisAngularVelocity() );
			client.getOutputStream().writeFloat( user.getZAxisAngularVelocity() );
			
//			if ( 0 == user.getForwardSpeed() ) {
//				System.out.println("SENT STOP!!!!!!!!!!!!!!!!");
//				System.out.println("         !!!!!!!!!!!!!!!!");
//			}
			
			
			client.debug("...sent.");
		} catch (IOException e) {
			client.log( e.getMessage() );
		}

	}

}
