package client.response;

import java.io.InputStream;

import client.MobileGameClient;

public abstract class ClientResponse implements Runnable {
	
	protected InputStream in = null;
	
	protected MobileGameClient client = null;
	
	/**
	 * Must call this before run() with a valid 
	 * MobileGameClient. 
	 * @param client valid game client
	 */
	public void setClient( MobileGameClient client ) {
		this.client = client;
	}
	
	public final void run() {
		doResponse();
	}
	
	/**
	 * Executes the client request.
	 */
	protected abstract void doResponse();
	
	
	public MobileGameClient getClient() {
		return client;
	}

	

}
