package client.response;

import javax.microedition.m3g.Mesh;

import client.Team;
import client.User;

public class ClientResponseAuthOK extends ClientResponse {
	
	long userID = -1;
	
	public long getUserId() {
		return userID;
	}

	public void doResponse() {
		try {
			userID = client.getInputStream().readLong();
			User myUser = new User();
			myUser.setId( userID );
			client.setMyUser( myUser );
			System.out.println("User ID: " + userID );
			
			// Info about all teams.
			long numTeams = client.getInputStream().readLong();
			System.out.println("# of teams " + numTeams);
			for ( int i = 0; i < numTeams; i++ ) {
				Team t = new Team();
				t.setId( client.getInputStream().readLong() );
				t.setName( client.getInputStream().readUTF() );
				t.setColor( client.getInputStream().readLong() );
				client.addTeam( t );
			}
			
			// number of users, then data for each user.
			long numUsers = client.getInputStream().readLong();
			System.out.println("# of users logged in: " + numUsers );
			for ( int i = 0; i < numUsers; i++ ) {
				User u;
				long thisUserId = client.getInputStream().readLong();
				if ( client.getUserId() == thisUserId ) {
					u = client.getMyUser();
				} else {
					u = new User();
					u.setId( thisUserId );
				}
				u.setName( client.getInputStream().readUTF() );
				u.setTeam( client.getTeam( client.getInputStream().readLong() ) );
				u.setModelId( client.getInputStream().readLong() );
				long modelId = u.getModelId();
				if ( client.getUserId() != thisUserId ) {
					// For non-clients, set the model.
					u.setModel( (Mesh)client.getModel( modelId ).duplicate() );
				}
				client.addUser( u );
			}
			
			
			
			// Sector data.
			long sectorID = client.getInputStream().readLong();
			System.out.println("Sector id " + sectorID );
			long numUsersInSector = client.getInputStream().readLong();
			System.out.println("# of users in sector " + numUsersInSector);
			for ( int i = 0; i < numUsersInSector; i++ ) {
				System.out.println(i + ")");
				
				// Create user object.
				long uid = client.getInputStream().readLong();
				System.out.println("  User ID: " + uid );
				User u;
				if ( uid != client.getUserId() ) {
					u = client.getUser( uid );
				} else {
					u = client.getMyUser();
				}
				
				// Last update.
				u.setLastMotionTime( client.getInputStream().readLong() );
				
				// Transform matrix.
				float[] transform = new float[16];
				for( int j = 0; j < transform.length; j++ ) {
					transform[j] = client.getInputStream().readFloat();
				}
				// Set user and model transform.
				u.setTransform( transform );
				if ( u.getId() != client.getUserId() ) {
					u.getModel().setTransform( u.getTransform() );
					client.canvas.world.addChild( u.getModel() ); // this results in duplicate models!!!
				}
				
				// Speed.
				float forwardSpeed = client.getInputStream().readFloat();
				float sidewaysSpeed = client.getInputStream().readFloat();
				float xAxisAngularVelocity = client.getInputStream().readFloat();
				float yAxisAngularVelocity = client.getInputStream().readFloat();
				float zAxisAngularVelocity = client.getInputStream().readFloat();
				u.setForwardSpeed( forwardSpeed );
				u.setSidewaysSpeed( sidewaysSpeed );
				u.setXAxisAngularVelocity( xAxisAngularVelocity );
				u.setYAxisAngularVelocity( yAxisAngularVelocity );
				u.setZAxisAngularVelocity( zAxisAngularVelocity );
			}
			
			// Now that everything is setup, tell the client to
			// star the 3d mode!
			client.start3dWorld();
			client.show3dWorld();
			
		} catch ( Exception e ) {
			client.log( "ClientResponseAuthOK: " + e.getMessage() );
		}

	}

}
