package client.response;

import java.io.IOException;

public class ClientResponseChatGlobal extends ClientResponse {

	protected void doResponse() {
		client.debug( "ClientResponseChatGlobal called" );
		long userId;
		String message;

		try {
			// Get user and message.
			userId = client.getInputStream().readLong();
			message = client.getInputStream().readUTF();			
			
			// Draw on chat screen.
			client.addToChat( client.getUser( userId ).getName(), message );
			
		} catch ( IOException e ) {
			client.log( "ClientResponseChatGlobal: IOException" );
			client.log( e.getMessage() );
		}
	}

}
