package client.response;

import javax.microedition.m3g.Mesh;


import client.Team;
import client.User;

public class ClientResponseGlobalUpdate extends ClientResponse {
	
	public void doResponse() {
		client.debug( "ResponseGlobalUpdate" );
		try {			
			// Info about all teams.
			
			long numTeams = client.getInputStream().readLong();
			client.debug( "# of teams " + numTeams );
			for ( int i = 0; i < numTeams; i++ ) {
				Team t = new Team();
				t.setId( client.getInputStream().readLong() );
				t.setName( client.getInputStream().readUTF() );
				t.setColor( client.getInputStream().readLong() );
				client.addTeam( t );
			}
			
			// number of users, then data for each user.
			long numUsers = client.getInputStream().readLong();
			client.debug( "# of users logged in: " + numUsers );
			for ( int i = 0; i < numUsers; i++ ) {
				// Get user ID and create if he doesn't exist.
				long thisUserId = client.getInputStream().readLong();
				User u = client.getUser( thisUserId );
				if ( null == u ) {
					client.debug( "Adding a new user: " + thisUserId );
					u = new User();
					u.setId( thisUserId );
					client.addUser( u );
				}				
				// Setup user.
				u.setName( client.getInputStream().readUTF() );
				u.setTeam( client.getTeam( client.getInputStream().readLong() ) );
				u.setModelId( client.getInputStream().readLong() );
				//u.setModel( client.getModel( u.getModelId() ) );
				u.setModel( (Mesh)client.getModel( u.getModelId() ).duplicate() );
			}
			
			
			
			// Sector data.
			long sectorID = client.getInputStream().readLong();
			System.out.println("Sector id " + sectorID );
			long numUsersInSector = client.getInputStream().readLong();
			System.out.println("# of users in sector " + numUsersInSector);
			for ( int i = 0; i < numTeams; i++ ) {
				System.out.println(i + ")");
				
				// Create user object.
				long uid = client.getInputStream().readLong();
				System.out.println("  User ID: " + uid );
				User u;
				if ( uid != client.getUserId() ) {
					u = client.getUser( uid );
				} else {
					u = client.getMyUser();
				}
				
				// Last update.
				u.setLastMotionTime( client.getInputStream().readLong() );
				
				// Transform matrix.
				float[] transform = new float[16];
				for( int j = 0; j < transform.length; j++ ) {
					transform[j] = client.getInputStream().readFloat();
					client.debug( j + " " + transform[j] );
				}
				u.setTransform( transform );
				
				// Speed.
				float forwardSpeed = client.getInputStream().readFloat();
				float sidewaysSpeed = client.getInputStream().readFloat();
				float xAxisAngularVelocity = client.getInputStream().readFloat();
				float yAxisAngularVelocity = client.getInputStream().readFloat();
				float zAxisAngularVelocity = client.getInputStream().readFloat();
				u.setForwardSpeed( forwardSpeed );
				u.setSidewaysSpeed( sidewaysSpeed );
				u.setXAxisAngularVelocity( xAxisAngularVelocity );
				u.setYAxisAngularVelocity( yAxisAngularVelocity );
				u.setZAxisAngularVelocity( zAxisAngularVelocity );
			}
			
		} catch ( Exception e ) {
			client.log( "ClientResponseAuthOK: " + e.getMessage() );
		}

	}

}
