package client.response;

import java.io.IOException;

import javax.microedition.m3g.Mesh;

import client.User;

/**
 * Another user has logged in after us.
 * @author Eric
 */
public class ClientResponseLogin extends ClientResponse {

	protected void doResponse() {
		client.log( "A new user is connecting!" );
		long userId;
		User user = new User();
		
		try {
			// Get user.
			userId = client.getInputStream().readLong();
			user.setId( userId );
			user.setName( client.getInputStream().readUTF() );
			user.setTeam( client.getTeam( client.getInputStream().readLong() ) );
			user.setModelId( client.getInputStream().readLong() );
			if ( user.getId() != client.getUserId() ) {
				user.setModel( (Mesh)client.getModel( user.getModelId() ).duplicate() );
				client.canvas.world.addChild( user.getModel() );
			}
			
			// TODO: sectors
			//user.setSector(  );
			client.getInputStream().readLong(); // sector ID
			
			// Transform matrix.
			float[] transform = new float[16];
			for( int j = 0; j < transform.length; j++ ) {
				transform[j] = client.getInputStream().readFloat();
				client.debug( j + " " + transform[j] );
			}
			user.setTransform( transform );
			
			// Speed.
			float forwardSpeed = client.getInputStream().readFloat();
			float sidewaysSpeed = client.getInputStream().readFloat();
			float xAxisAngularVelocity = client.getInputStream().readFloat();
			float yAxisAngularVelocity = client.getInputStream().readFloat();
			float zAxisAngularVelocity = client.getInputStream().readFloat();
			user.setForwardSpeed( forwardSpeed );
			user.setSidewaysSpeed( sidewaysSpeed );
			user.setXAxisAngularVelocity( xAxisAngularVelocity );
			user.setYAxisAngularVelocity( yAxisAngularVelocity );
			user.setZAxisAngularVelocity( zAxisAngularVelocity );
				
			// Add new users to the server.
			if ( client.getUserId() != userId ) {
				client.addUser( user );
			}
		} catch ( IOException e ) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

	}

}
