package client.response;

import java.io.IOException;

import client.User;

/**
 * A user logs out. This notifies us to remove them from
 * the client-side list of logged in users.
 * 
 * @author Eric
 */
public class ClientResponseLogout extends ClientResponse {

	public void doResponse() {
		client.log( "A user has disconnected." );
		long userId;
		User user;
		
		try {
			// Get user.
			userId = client.getInputStream().readLong();
			if ( client.getUserId() == userId ) {
				// The user IS the client (oh noes!)
				// Do nothing. This will be handled
				// elsewhere.
			} else {
				// The user is NOT the client.  Remove
				// him from the client's list.
				user = client.getUser( userId );
				client.removeUser( user );
				if ( client.getMyUser() != user ) {
					client.canvas.world.removeChild( user.getModel() );
				}
			}
		} catch ( IOException e ) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		

	}

}
