package client.response;

import java.io.IOException;


import client.User;

public class ClientResponseMotion extends ClientResponse {

	public void doResponse() {
		client.debug( "ClientResponseMotion called" );
		long userId;
		User user;
		float[] transform = new float[16];
		try {
			// Get user.
			userId = client.getInputStream().readLong();
			client.debug( "   userId: " + userId );
			if ( client.getUserId() == userId ) {
				user = client.getMyUser();
			} else {
				user = client.getUser( userId );
			}
			
			// Transform matrix.
			for( int j = 0; j < transform.length; j++ ) {
				transform[j] = client.getInputStream().readFloat();
			}
			client.debug( "   got a transform matrix" );
			
			// Velocities
			float forwardVelocity = client.getInputStream().readFloat();
			float sidewaysVelocity = client.getInputStream().readFloat();
			float xAxisAngularVelocity = client.getInputStream().readFloat();
			float yAxisAngularVelocity = client.getInputStream().readFloat();
			float zAxisAngularVelocity = client.getInputStream().readFloat();
			
			
			
			user.setForwardSpeed( forwardVelocity );
			user.setSidewaysSpeed( sidewaysVelocity );
			user.setXAxisAngularVelocity( xAxisAngularVelocity );
			user.setYAxisAngularVelocity( yAxisAngularVelocity );
			user.setZAxisAngularVelocity( zAxisAngularVelocity );
			
			client.debug( "Set transform");			
			user.setTransform( transform );
			
			// Remember the time (that we first met girl)
			user.setLastMotionTime( client.currentTime() );
			
			client.debug( "... done!!" );
			
		} catch ( IOException e ) {
			client.log( "ClientResponseMotion: ioexception" );
			client.log( e.getMessage() );
		} catch ( NullPointerException e ) {
			client.log( "ClientResponseMotion: NullPointerException" );
			client.log( e.getMessage() );
		} catch ( IllegalArgumentException e ) {
			client.log( "ClientResponseMotion: IllegalArgumentException" );
			client.log( e.getMessage() );
		}
		
	}


}
