package client.response;

import java.io.IOException;
import java.util.Vector;

import client.screens.QuestionChoice;

public class ClientResponseQuestionChoice extends ClientResponse {
	
//	 The question!
	private String question;
	
	// Choices for this question.
	private Vector choices = new Vector(); 

	
	public void doResponse() {
		try {
			client.debug("ClientResponseQuestionChoice");
			question = client.getInputStream().readUTF();
			
			// Number of questions, then itteratively add 'em.
			int max = client.getInputStream().readInt();
			for ( int i = 0; i < max; i++ ) {
				addChoice( client.getInputStream().readChar(), client.getInputStream().readUTF() );
			}
			
			client.debug("Doing quiz screen");
			
			// Now make the question screen appear.
			QuestionChoice screen = new QuestionChoice( client );
			setScreen( screen );
			screen.start();
			
		} catch (IOException e) {
			client.log( e.getMessage() );
		}
	}
	
	/**
	 * Sets up an individual choice.
	 * @param id code for the choice (i.e. a, b, c...)
	 * @param msg text message of choice (i.e. "Pluto")
	 */
	private void addChoice( char id, String msg ) {
		Choice c = new Choice();
		c.id = id;
		c.msg = msg;
		choices.addElement( c );
		System.out.println( id + " " + msg );
	}
	
	// The choices we make!
	class Choice {
		public char id;
		public String msg;
	}

	/**
	 * Sets up object of the corresponding screen type.
	 * @param screen
	 */
	public void setScreen( QuestionChoice screen ) {
		screen.setQuestion( question );
		for ( int i = 0; i < choices.size(); i++ ) {
			Choice c = (Choice)choices.elementAt( i );
			screen.addChoice( c.id, c.msg );
		}
		
	}

}
