package client.screens;

import java.io.IOException;

import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;

import client.MobileGameClient;
import client.request.ClientRequestChatGlobal;

public class Chat extends Screen implements CommandListener {
	
	
	// Commands
	private Command exit = new Command( "Exit", Command.EXIT, 1 );
	private Command send = new Command( "Send", Command.OK, 1 );
	
	//Input box.
	private TextField text = null;
	
	// Form
	private Form form = null;
	
	// Running total of the height of all items.
	private int itemHeight = 0;
	
	/**
	 * C'tor.
	 * @param client
	 */
	public Chat( MobileGameClient client ) {
		super( client );
	}

	/**
	 * Initializes this screen.
	 */
	public void start() {
		form = new Form("Chat");
		form.setCommandListener( this );
		form.addCommand( exit );
		form.addCommand( send );

		
		text = new TextField( "Chat:", "", 200, 0 );
		text.setLayout( TextField.LAYOUT_VEXPAND );
		text.setPreferredSize( form.getWidth() , (int)( form.getHeight() * 0.10 ) );
		form.append(text);
		itemHeight += text.getPreferredHeight();
	}
	
	
	/**
	 * Shows this screen.
	 */
	public void show() {
		Display.getDisplay( getClient() ).setCurrent( form );
		getClient().setUnreadChat( false );
	}

	
	/**
	 * Writes a chat message.
	 * @param name
	 * @param message
	 */
	public void addChatText( String name, String message ) {
		StringItem chatText = new StringItem( name + ":", message );
		chatText.setLayout( StringItem.LAYOUT_NEWLINE_AFTER );
		form.append(chatText);
		itemHeight += chatText.getPreferredHeight();
		
		while ( form.getHeight()-50 <= itemHeight ) {
			if ( form.size() < 2 ) break;
			itemHeight -= form.get(1).getPreferredHeight();
			form.delete( 1 );
		}
		
		if ( form == Display.getDisplay( getClient() ).getCurrent() ) {
			getClient().setUnreadChat( false );
		} else {
			getClient().setUnreadChat( true );
		}
	}

	
	public void commandAction( Command c, Displayable arg1 ) {
		if ( c == exit ) {
			// Return to game.
			getClient().show3dWorld();
		} else if ( c == send ) {
			// Take care of GUI
			String message = text.getString();
			text.setString("");
			addChatText( getClient().getMyUser().getName(), message );
			
			// Send response.
			ClientRequestChatGlobal req = new ClientRequestChatGlobal();
			req.setUserId( getClient().getUserId() );
			req.setMessage( message );
			try {
				getClient().sendRequest( req );
			} catch (IOException e) {
				getClient().log( e.getMessage() );
			}
		}
	}
	
	


	

}
