package client.screens;


import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDletStateChangeException;

import client.MobileGameClient;

public class Login extends Screen implements CommandListener {
	
	private Command login = new Command( "Login", Command.OK, 0 );
	private Command exit = new Command( "Exit", Command.EXIT, 1 );
	
	private String errorText = "";
	
	TextField userField = new TextField( "Username", "", 20, TextField.PLAIN );
	TextField passField = new TextField( "Password", "", 20, TextField.PASSWORD );
	
	public Login( MobileGameClient client ) {
		super(client);
	}	

	public void start() {
		Form f = new Form("Login");
		f.append( errorText );
		f.append( userField );	
		f.append( passField );
		f.addCommand( login );
		f.addCommand( exit );
		f.setCommandListener( this );
		getDisplay().setCurrent( f );
	}

	public void commandAction( Command c, Displayable d ) {
		if ( c == login ) {
			// Pass login data to client.
			getClient().login( userField.getString(), passField.getString() );
		} else if ( c == exit ) {
			// You just quit the game.
			try {
				getClient().destroyApp(false);
				getClient().notifyDestroyed();
			} catch (MIDletStateChangeException e) {
				getClient().log( e.getMessage() );
			}
		}
	}
	
	public void setErrorText( String error ) {
		errorText = error;
	}
	
	

}
