package client.screens;

import java.io.IOException;
import java.util.Vector;

import javax.microedition.lcdui.Choice;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemStateListener;

import client.MobileGameClient;
import client.request.ClientRequestAnswerQuestionChoice;
import client.request.ClientRequestQuizEnd;

/**
 * Multiple choice question screen.
 * @author Eric
 *
 */
public class QuestionChoice extends Screen implements CommandListener, ItemStateListener  {
	
	// Exit quiz.
	private Command exit = new Command( "Exit", Command.EXIT, 1 );
	
	// Quiz list.
	//private List list;
	private ChoiceGroup list;
	
	private Form form;
	
	private Vector choices = new Vector();
	
	public QuestionChoice( MobileGameClient client ) {
		super(client);
	}	
	
	/**
	 * Call this with the question text.
	 * @param q
	 */
	public void setQuestion( String q ) {
		form = new Form( "Quiz" );
		list = new ChoiceGroup( q, ChoiceGroup.MULTIPLE );
		list.setFitPolicy( ChoiceGroup.TEXT_WRAP_ON );
		//list.setTitle( q ); 
		form.append( list );
	}
	
	/**
	 * Add a choice to this question.
	 * @param c
	 * @param option
	 */
	public void addChoice( char c, String option ) {
		ChoiceItem choice = new ChoiceItem();
		choice.id = c;
		choice.msg = option;
		choices.addElement( choice );
		list.append( option, null );
	}

	public void start() {
		form.addCommand( exit );
		form.setCommandListener( this );
		form.setItemStateListener( this );
		getDisplay().setCurrent( form );
	}

	
	public void commandAction( Command c, Displayable d ) {
		if ( c == exit ) {
			try {
				// End quiz.
				ClientRequestQuizEnd req = new ClientRequestQuizEnd();
				getClient().sendRequest( req );
			} catch ( IOException e ) {
				getClient().log( e.getMessage() );
			}
			// Go back to game.
			getClient().resumeGame();
		}
		
	}
	
	public void itemStateChanged( Item item ) {
		Choice c = ( Choice )item;
		int selected = -1;
		int count = c.size();
		boolean[] states = new boolean[ count ];
		c.getSelectedFlags( states );
		for ( int i = 0; i < count; i++ ) {
			if ( states[i] ) {
				selected = i;
				break;
			}
		}
		ClientRequestAnswerQuestionChoice req = new ClientRequestAnswerQuestionChoice();
		getClient().debug( "User selected: " + selected );
		req.setChoice( ((ChoiceItem)choices.elementAt( selected )).id );
		
		try {
			getClient().sendRequest( req );
		} catch ( IOException e ) {
			getClient().log( "QuestionChoice screen couldn't send response. " );
			e.printStackTrace();
		}
		return;
	
	}
	
	// The choices we make!
	class ChoiceItem {
		public char id;
		public String msg;
	}

}
