package client.screens;

import java.io.IOException;

import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;

import client.MobileGameClient;
import client.request.ClientRequestQuizEnd;

public class QuestionResult extends Screen implements CommandListener {
	
	// Customizable text.
	private String textCorrect = "Correct! :)";
	private String textIncorrect = "Nope, better luck next time.";
	
	// Commands.
	private Command next = new Command( "Continue", Command.OK, 1 );
	private Command exit = new Command( "Exit", Command.EXIT, 2 );
	
	// Whether answer was correct.
	private boolean correct;

	public QuestionResult(MobileGameClient client) {
		super(client);
	}
	
	public void setCorrect( boolean correct ) {
		this.correct = correct;
	}

	public void start() {
		Form f = new Form( "Result" );
		if ( correct ) {
			f.append( textCorrect );
		} else {
			f.append( textIncorrect );
		}
		f.addCommand( next );
		f.addCommand( exit );
		f.setCommandListener( this );
		getDisplay().setCurrent( f );
	}

	public void commandAction( Command c, Displayable d ) {
		if ( c == next ) {
			getClient().nextQuestion();
		} else if ( c == exit ) {
			try {
				// End quiz.
				ClientRequestQuizEnd req = new ClientRequestQuizEnd();
				getClient().sendRequest( req );
			} catch ( IOException e ) {
				getClient().log( e.getMessage() );
			}
			// Go back to game.
			getClient().resumeGame();
			
		}
		
	}

}
