package client.screens;

import javax.microedition.lcdui.Display;

import client.MobileGameClient;

public abstract class Screen {
	
	// Display object.
	private Display disp;
	
	// Client.
	private MobileGameClient client;

	/**
	 * Start displaying this screen.
	 */
	public abstract void start();
	
	public Screen( MobileGameClient client ) {
		super();
		this.client = client;
		disp = Display.getDisplay( client );
	}
	
	public MobileGameClient getClient() {
		return client;		
	}
	
	protected Display getDisplay() {
		return disp;
	}

}
