package core;

/**
 * Constants shared by the client and server.
 * 
 * @author eric
 */
public class Constants {
	
	// Requests. //////////////////////////////////////////
	public final static int REQ_HEARTBEAT 		= 0; 
	public final static int REQ_LOGIN 			= 1;
	public final static int REQ_LOGOUT 			= 2;
	public final static int REQ_SIGNUP 			= 3;
	public final static int REQ_GLOBAL_UPDATE	= 10;
	//...
	public final static int REQ_MOTION			= 20;
	//...
	public final static int REQ_ANIMATION 		= 30;
	//...
	public final static int REQ_LEAVE 			= 40;
	public final static int REQ_ENTER 			= 41;
	//...
	public final static int REQ_CHAT_GLOBAL		= 50;
	public final static int REQ_CHAT_SECTOR		= 51;
	public final static int REQ_CHAT_TEAM		= 52;
	public final static int REQ_CHAT_PRIVATE	= 53;
	//...
	public final static int REQ_BUDDY_LIST		= 60;
	public final static int REQ_BUDDY_ADD		= 61;
	public final static int REQ_BUDDY_REMOVE	= 62;
	public final static int REQ_BUDDY_STATUS_CHANGE	= 63;
		
	
	
	// Responses. /////////////////////////////////////////
	public final static int RESP_AUTH_OK		= 0;
	public final static int RESP_AUTH_REJECTED	= 1;
	public final static int RESP_DISCONNECTED	= 2;
	public final static int RESP_GLOBAL_UPDATE	= 10;
	//..
	public final static int RESP_MOTION			= 20;
	public final static int RESP_LOGIN 			= 21;
	public final static int RESP_LOGOUT 		= 22;
	public final static int RESP_ANIMATION		= 30;
	public final static int RESP_LEAVE			= 40;
	public final static int RESP_ENTER			= 41;
	//...
	public final static int RESP_CHAT_GLOBAL	= 50;
	public final static int RESP_CHAT_SECTOR	= 51;
	public final static int RESP_CHAT_TEAM		= 52;
	public final static int RESP_CHAT_PRIVATE	= 53;
	public final static int RESP_BUDDYLIST		= 60;
	public final static int RESP_BUDDY_STATUS	= 61;
	
	
	
	// Buddy status options.
	public final static int BUDDY_STATUS_AVAILABLE		= 0;
	public final static int BUDDY_STATUS_OFFLINE		= 1;
	public final static int BUDDY_STATUS_DO_NOT_DISTURB	= 2;
	public final static int BUDDY_STATUS_AWAY			= 3;
	
}
