package core;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;

/**
 * Class of game DB functions.
 * @author eric
 */
public class GameDB {
	
	// Connection to database.
	// Might consider moving this (see c'tor.)
	protected Connection conn = null;
	
	// The GameServer object.
	protected GameServer server = null;
	
	/**
	 * Connects to the DB.
	 * 
	 * TODO: is this thread-safe?  What
	 * can be done to use threads efficiently
	 * in a mult-threaded environment?
	 * @throws SQLException 
	 */
	public GameDB( GameServer gs ) throws SQLException {
		this.server = gs;
		conn = 
			DriverManager.getConnection("jdbc:mysql://" + 
					GameDBConfig.url + "/" + 
					GameDBConfig.dbName + "?" + 
		            "user=" + GameDBConfig.user + 
		            "&password=" + GameDBConfig.password );
	}
	
	/**
	 * Creates a character in the DB.
	 * @return character ID number
	 *   -1 means username already in use
	 *   -2 means username is invalid
	 *   -3 means password is invalid
	 *   -4 
	 * @throws SQLException 
	 */
	public long createUser( String name, String password ) throws SQLException {
		conn.prepareStatement("INSERT INTO users ");
		// TODO
		return 0;
	}
	
	
	
	/**
	 * Sets the a value.  Will create a DB entry
	 * if none exists.
	 * WARNING: this function is not thread-safe!
	 * Recommended to use only when creating a character!
	 */
	public void setUserValue( String valueName, long userId, long value ) {
		// TODO
	}
	
	/**
	 * Increase a value associated with a character.
	 * @param value
	 */
	public void increaseUserValue( String valueName, long userId, long value ) {
		// TODO
	}
	
	/**
	 * Decrease a value associated with a user.
	 * @param value
	 */
	public void decreaseUserValue( String valueName, long userId, long value ) {
		// TODO
	}	
	
	/**
	 * Fetch a value from the database associated
	 * with a character.
	 * @return value.
	 */
	public long getUserValue() {
		// TODO
		return 0; 
	}
	
	/**
	 * Loads all teams to game server.
	 */
	public HashMap<Long, Team> getTeams() {
		ResultSet rs = null;
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement( "SELECT * FROM teams" );
            rs = ps.executeQuery();
            
            // If we can't access the row, the username/password is
            // invalid so return null.
            while ( rs.next() ) {
            	Team t = new Team();
            	t.setName( rs.getString( "teamname" ) );
            	t.setId( rs.getInt( "team_id" ) );
            	t.setColor( rs.getInt( "color" ) );
            	server.addTeam( t );
            }            
        } catch ( Exception e ) {
        	server.log( e.getMessage() );
        }
        
        return null; // On error.
	}

}
