package core;

import java.util.HashMap;

public class GameRequestTable {

	/**
	 * Sets up GameRequest table.
	 */
	public static void init() {
		requestNames = new HashMap< Integer, Class >();
		
		// First var is an int (0...65535)
		// Second var is a class name.
		try {
			add( Constants.REQ_HEARTBEAT, 		"core.request.RequestHeartbeat" ); 
			add( Constants.REQ_LOGIN, 			"core.request.RequestLogin" );
			add( Constants.REQ_LOGOUT, 			"core.request.RequestLogout" );
			add( Constants.REQ_SIGNUP, 			"core.request.RequestSignup" );
			add( Constants.REQ_GLOBAL_UPDATE, 	"core.request.RequestGlobalUpdate" );
			add( Constants.REQ_CHAT_GLOBAL,		"core.request.RequestChatGlobal" );
			add( Constants.REQ_CHAT_TEAM,		"core.request.RequestChatTeam" );
			add( Constants.REQ_CHAT_SECTOR,		"core.request.RequestChatSector" );
			add( Constants.REQ_CHAT_PRIVATE,	"core.request.RequestChatPrivate" );
			add( Constants.REQ_MOTION, 			"core.request.RequestMotion" );
			add( Constants.REQ_ANIMATION, 		"core.request.RequestAnimation" );
			add( Constants.REQ_LEAVE, 			"core.request.RequestLeave" );
			add( Constants.REQ_ENTER, 			"core.request.RequestEnter" );
		} catch (ClassNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	
	/**
	 * Adds a game request
	 * @param c first int value 0..65535 of the request
	 * @param req the GameRequest child class
	 * @throws ClassNotFoundException 
	 */
	public static void add( int c, String name ) throws ClassNotFoundException {
		Class req = Class.forName( name );
		requestNames.put( new Integer( c ), req );
	}
	
	/** 
	 * Gets the name of the class corresponding with 
	 * a GameRequest
	 * 
	 * @param GameRequest name
	 * @return class name
	 * @throws IllegalAccessException 
	 * @throws InstantiationException 
	 */
	public static core.request.GameRequest get( int requestID ) throws InstantiationException, IllegalAccessException {
		return (core.request.GameRequest) requestNames.get( requestID ).newInstance();
	}
	
	/**
	 * Mapping of names of requests to corresponding class name.
	 */
	private static HashMap< Integer, Class > requestNames;

}
