package core;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;

import core.request.GameRequest;

/**
 * Thread to deal with incoming data from a client socket.
 * 
 * @author eric
 */
public class SocketReaderThread extends Thread {
	
	private Socket clientSocket = null;
	
	private GameServer gs = null;
	
	/**
	 * Sets up a work thread.
	 * @param gs the Game Server
	 * @param s a valid socket object (will close and exit otherwise)
	 */
	public SocketReaderThread( GameServer gs, Socket s ) {
		this.gs = gs;
		clientSocket = s;
	}
	
	/**
	 * Accepts data from client as long as the connection is
	 * valid.
	 */
	public void run() {
		InputStream in;
		DataInputStream data;
		try {
			in = clientSocket.getInputStream();
			data = new DataInputStream( in );
			
			gs.log( "Client connect" );
		
			// Loop during life of client socket.
			while ( !clientSocket.isClosed() ) {

			    // Get request code and create instance of GameRequest.
			    int requestCode = data.readInt();
			    gs.debug( "Req id = " + requestCode );
			    GameRequest gr = GameRequestTable.get( requestCode );
			    gs.debug( "Req name = " + gr.getClass().getName() );
				
				// Setup the game request, parse, and
			    // send to work queue for execution.
				gr.set( clientSocket, in, gs );
				gr.parse();
				gs.getWorkQueue().execute( gr );
			}
			
		} catch ( IOException e ) {
			gs.log( e.getMessage() );
		} catch (InstantiationException e) {
			gs.log( e.getMessage() );
		} catch (IllegalAccessException e) {
			gs.log( e.getMessage() );
		} finally {
			if ( null != clientSocket ) {
				try {
					clientSocket.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
		}
		
		gs.log( "Client disconnect" );
		
	}

}
