package core;

import java.util.LinkedList;

import core.request.GameRequest;

/**
 * Class for safe thread queues.
 * 
 * See this URL:
 * http://www.ibm.com/developerworks/library/j-jtp0730.html
 * 
 * @author Brian Goetz (brian@quiotix.com), Principal Consultant, Quiotix Corp
 *
 */
public class WorkQueue
{
    //private final int nThreads;
    private final PoolWorker[] threads;
    private final LinkedList<GameRequest> queue;

    public WorkQueue(int nThreads)
    {
        //this.nThreads = nThreads;
        queue = new LinkedList<GameRequest>();
        threads = new PoolWorker[nThreads];

        for (int i=0; i<nThreads; i++) {
            threads[i] = new PoolWorker();
            threads[i].start();
        }
    }

    public void execute(GameRequest r) {
        synchronized(queue) {
            queue.addLast(r);
            queue.notify();
        }
    }

    private class PoolWorker extends Thread {
        public void run() {
        	GameRequest r;

            while (true) {
                synchronized(queue) {
                    while (queue.isEmpty()) {
                        try
                        {
                            queue.wait();
                        }
                        catch (InterruptedException ignored)
                        {
                        }
                    }

                    r = queue.removeFirst();
                }

                // If we don't catch RuntimeException, 
                // the pool could leak threads
                try {
                	if ( r.getUser() != null ) {
                		synchronized ( r.getUser() ) { 
                			r.run();
                		}
                	} else {
                		r.run();
                	}
                }
                catch (RuntimeException e) {
                    // You might want to log something here
                	System.out.println("Work queue error.");
                	System.out.println(e.getMessage());
                }
            }
        }
    }
}

