package core.request;

import core.User;
import core.response.ResponseAnimation;

public class RequestAnimation extends GameRequest{
	private long userId = -1;
	private long animationId = -1;

	@Override
	public void parse() {
		
		try {
			// Get the user id
			userId = getData().readLong();
						
			// I assume here we have animation id sent after user id
			// and user will not both move and change animation
			// so here, the user will not move
			animationId = getData().readLong();
		} catch (Exception e) {
			gs.log("Error: In User animation handling.");
			gs.log( e.getMessage() );
		}
	}
	
	
	@Override
	public void run() {
		// Let the game server handle this animation request
		if ((userId < 0) || (animationId < 0)) {
			gs.log("Error: Can not get user Id in requestAnimation.");
			return;
		}
		
		User myUser = gs.getUser( userId );
		myUser.updateAnimation( animationId );
		
		// TODO: change to send response ONLY to users in
		// this user's sector!
		
		// Send response to all users.
		for ( User u : gs.getUserList() ) {
			if ( u != myUser ) {
				ResponseAnimation resp = new ResponseAnimation();
				resp.setOutputStream( u.getOutputStream() );
				resp.set( gs );
				resp.setUserId( userId );
				resp.setAnimationId( animationId );
				resp.run();
			}
		}
	
	}
	
}
