package core.request;

import java.io.IOException;

import core.User;
import core.response.ResponseChatGlobal;

public class RequestChatGlobal extends GameRequest {
	
	// User who requested chat (from user)
	private long userId = -1;
	
	// Chat message.
	private String message;

	@Override
	public void parse() {
		try {
			userId = getData().readLong();
			message = getData().readUTF();
		} catch (IOException e) {
			gs.log( e.getMessage() );
		}
	}
	
	
	@Override
	public void run() {
		// Find the user who sent this request.
		User myUser = gs.getUser( userId );
		
		// Send response to all other users.
		for ( User u : gs.getUserList() ) {
			if ( u != myUser ) {
				ResponseChatGlobal resp = new ResponseChatGlobal();
				resp.setOutputStream( u.getOutputStream() );
				resp.set( gs );
				resp.setUser( myUser );
				resp.setMessage( message );
				resp.run();
			}
		}
	}
	

}
