package core.request;

import java.io.IOException;

import core.User;
import core.response.ResponseChatPrivate;

public class RequestChatPrivate extends GameRequest {
	
	// User who requested chat (from user)
	private long userId = -1;
	
	// User who chat should be sent to.
	private long toUserId = -1;
	
	// Chat message.
	private String message;

	@Override
	public void parse() {
		try {
			userId = getData().readLong();
			toUserId = getData().readLong();
			message = getData().readUTF();
		} catch (IOException e) {
			gs.log( e.getMessage() );
		}
	}
	
	
	@Override
	public void run() {
		// Find the user who sent this request.
		User myUser = gs.getUser( userId );
		
		// Update the recieving user.
		User toUser = gs.getUser( toUserId );
		
		// Send response to the specified user
		ResponseChatPrivate resp = new ResponseChatPrivate();
		resp.setOutputStream( toUser.getOutputStream() );
		resp.set( gs );
		resp.setUser( myUser );
		resp.setMessage( message );
		resp.run();
	}

}
