package core.request;

import java.io.IOException;

import core.Team;
import core.User;
import core.response.ResponseChatTeam;

public class RequestChatTeam extends GameRequest {

	// User who requested chat (from user)
	private long userId = -1;
	
	// Chat message.
	private String message;

	@Override
	public void parse() {
		try {
			userId = getData().readLong();
			user = gs.getUser( userId );
			message = getData().readUTF();
			gs.log( "Chat request: " + user.getName() + " " + message );
		} catch (IOException e) {
			gs.log( e.getMessage() );
		}
	}
	
	@Override
	public void run() {
		// Find the user who sent this request.
		User myUser = gs.getUser( userId );
		
		Team team = myUser.getTeam();
		
		// Send response to all other users.
		for ( User u : team.getAllMembers() ) {
			if ( u != myUser ) {
				ResponseChatTeam resp = new ResponseChatTeam();
				resp.setOutputStream( u.getOutputStream() );
				resp.set( gs );
				resp.setUser( myUser );
				resp.setMessage( message );
				resp.run();
			}
		}
	}
	
}
