package core.request;


public class RequestEnter extends GameRequest{
	private long userId = -1;
	private long sectorId = -1;

	@Override
	public void parse() {
		try {
			// Get the user id
			userId = getData().readLong();
						
			// I assume here we have sector id sent after user id
			// and client sends out the sector id which the user
			// would like to enter
			sectorId = getData().readLong();
			
			
		} catch (Exception e) {
			gs.log("Error: In User enter sector handling.");
			e.printStackTrace();
		}
		
		
	}
	
	@Override
	public void run() {
		// Let the game server handle this enter request
		if ((userId < 0) || (sectorId < 0)) {
			gs.log("Error: Can not get user Id in requestEnter.");
		} else {
			gs.userEnterSector(userId, sectorId, this);
		}
		
		// Send response.
		// TODO
//		ResponseUpdate res = new ResponseUpdate();
//		res.set( gs );
//		res.setUser( gs.getUser(userId) );
//		try {
//			res.setOutputStream( socket.getOutputStream() );
//			res.run();
//		} catch ( IOException e ) {
//			gs.log( e.getMessage() );
//		}
	}
	
//	@Override
//	public void writeResponseUpdate( OutputStream out ) {
//		try {
//			// Send team chat message id
//			DataOutputStream data = new DataOutputStream( out );
//			data.writeInt( Constants.RESP_UPDATE_ENTER );
//			data.writeLong( userId );
//			data.writeLong( sectorId );
//		} catch (IOException e) {
//			gs.log( e.getMessage() );
//		}
//	}
	
}

