package core.request;

import java.io.IOException;

import core.response.ResponseGlobalUpdate;

public class RequestGlobalUpdate extends GameRequest {
	
	private long userId = -1;

	@Override
	public void parse() {
		// Get userid from socket.
		try {
			userId = getData().readLong();
		} catch (IOException e) {
			gs.log( "RequestHeartbeat could not reat from socket." );
			gs.log( e.getMessage() );
		}
	}

	@Override
	public void run() {
		user = gs.getUser( userId );
		user.turnUpdatesOn();
		
		// Sends a ResponseGlobalUpdate customized for
		// the user.
		try {
			ResponseGlobalUpdate response = new ResponseGlobalUpdate();
			response.set( gs );
			response.setUser( user );
			response.setOutputStream( getSocket().getOutputStream() );
			response.run();
		} catch ( IOException e ) {
			gs.log( e.getMessage() );
		}
	}

}
