package core.request;

import java.io.IOException;


/**
 * This request sends only a userid to the server.
 * 
 * It's used only for the client user to get a 
 * response back from the server, since firewalls
 * and NATs don't allow responses without a request. 
 * 
 * Request format:
 *   int 0 (for request id)
 *   int userId
 * 
 * @author eric
 */
public class RequestHeartbeat extends GameRequest {
	
	private long userId = -1;

	@Override
	public void parse() {
		// Get userid from socket.
		try {
			userId = getData().readLong();
		} catch (IOException e) {
			gs.log( "RequestHeartbeat could not reat from socket." );
			gs.log( e.getMessage() );
		}
	}
	
	@Override
	public void run() {
		user = gs.getUser( userId );
		
		// Send response.
//		ResponseUpdate res = new ResponseUpdate();
//		res.set( gs );
//		res.setUser( gs.getUser(userId) );
//		try {
//			res.setOutputStream( socket.getOutputStream() );
//			res.run();
//		} catch ( IOException e ) {
//			gs.log( e.getMessage() );
//		}
	}

}
