package core.request;

import java.io.IOException;

import core.User;
import core.response.ResponseAuthOK;
import core.response.ResponseAuthRejected;
import core.response.ResponseLogin;

/**
 * Logs in the client character.
 * 
 * @author eric
 */
public class RequestLogin extends GameRequest {
	
	private String username = null;
	private String password = null;
	private long userId = -1;

	@Override
	public void parse() {
		// Get character name and password from socket.
		try {
			username = getData().readUTF();
			password = getData().readUTF();
		} catch ( IOException e ) {
			gs.log( e.getMessage() );
		}
	}
	
	@Override
	public void run() {
		userId = gs.login( username, password );
		user = gs.getUser( userId );
		
		// Log in to server and send response.
		try {
			user.setOutputStream( this.socket.getOutputStream() );
			if ( user != null ) {
				// Send login OK response.
				ResponseAuthOK response = new ResponseAuthOK();
				response.set( gs );
				response.setUser( user );
				response.setOutputStream( getSocket().getOutputStream() );
				response.run();
				
				// Tell everyone (else) we logged on!
				for ( User other : gs.getUserList() ) {
					if ( other != user ) {
						ResponseLogin resp = new ResponseLogin();
						resp.setOutputStream( other.getOutputStream() );
						resp.set( gs );
						resp.setUser( user );
						resp.run();
					}
				}
			} else {
				// Send error response.
				ResponseAuthRejected response = new ResponseAuthRejected();
				response.set( gs );
				response.setOutputStream( getSocket().getOutputStream() );
				response.run();
			}
		} catch ( IOException e ) {
			gs.log( e.getMessage() );
		}
	}
	

}

