package core.request;

import java.io.IOException;

import core.User;
import core.response.ResponseDisconnected;
import core.response.ResponseLogout;

public class RequestLogout extends GameRequest {
	
	private long userid = -1;

	@Override
	public void parse() {
		// Get userid from socket.
		try {
			userid = getData().readLong();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	
	@Override
	public void run() {
		// Log out user.
		gs.log( "Logging out user id " + userid );
		user = gs.getUser( userid );
		if ( null != user ) {
			user.getSector().removeUser( user );
			user.getTeam().removeMember( user );
			gs.removeUser( user );
		}

		// Send ResponseDisconnected.
		ResponseDisconnected resp = new ResponseDisconnected();
		resp.set( gs );
		try {
			resp.setOutputStream( socket.getOutputStream() );
			resp.run();
		} catch ( IOException e ) {
			gs.log( e.getMessage() );
		}
		
		// Kill the connection.
		try {
			socket.close();
		} catch ( IOException e ) {
			gs.log( e.getMessage() );
		}
		
		//	Tell everyone we logged out
		for ( User other : gs.getUserList() ) {
			if ( other != user ) {
				ResponseLogout respLogout = new ResponseLogout();
				respLogout.setOutputStream( other.getOutputStream() );
				respLogout.set( gs );
				respLogout.setUser( user );
				respLogout.run();
			}
		}
	}
}
