package core.request;

import core.User;
import core.response.ResponseMotion;

/**
 * All motion updates use this type of request.
 * 
 * @author eric
 */
public class RequestMotion extends GameRequest {
	
	// ID of user.
	private long userId = -1;
	
	// Transform matrix from request.
	private float[] transform = new float[16];
	
	// Velocities.
	private float forwardVelocity;
	private float sidewaysVelocity;
	private float xAxisAngularVelocity;
	private float yAxisAngularVelocity;
	private float zAxisAngularVelocity;
	
	
	@Override
	public void parse() {
		try {
			// Get the user id
			userId = getData().readLong();
			
			// Get transform matrix.
			for( int i = 0; i < transform.length; i++ ) {
				transform[i] = getData().readFloat();
			}
			
			// Get velocities.
			forwardVelocity = getData().readFloat();
			sidewaysVelocity = getData().readFloat();
			xAxisAngularVelocity = getData().readFloat();
			yAxisAngularVelocity = getData().readFloat();
			zAxisAngularVelocity = getData().readFloat();
		} catch ( Exception e ) {
			gs.log( "RequestMotion error: " + e.getMessage() );
		}
		
	}

	@Override
	public void run() {
		user = gs.getUser( userId );
		if ( user == null ) {
			gs.log("Error: Can not get user in RequestMotion.");
			return;
		} else {
			user.setTransform( transform );
			user.setLastMotionTime( gs.currentTime() );
			user.setForwardSpeed( forwardVelocity );
			user.setSidewaysSpeed( sidewaysVelocity );
			user.setXAxisAngularVelocity( xAxisAngularVelocity );
			user.setYAxisAngularVelocity( yAxisAngularVelocity );
			user.setZAxisAngularVelocity( zAxisAngularVelocity );
		}
		
		// Let 'em know about this.
		// TODO: should be sectors, not global!
		for ( User u : gs.getUserList() ) {
			if ( u != user ) {
				ResponseMotion resp = new ResponseMotion();
				resp.setOutputStream( u.getOutputStream() );
				resp.set( gs );
				resp.setUser( user );
				resp.run();
			}
		}
		
	}
	

}
