package core.response;

import java.io.DataOutputStream;
import java.io.OutputStream;

import core.GameServer;

/**
 * Used for sending a response back to the client.
 * Create a version of this for each response type.
 * 
 * @author eric
 */
public abstract class GameResponse implements Runnable {
	
	// GameServer object.
	protected GameServer gs = null;
	
	private DataOutputStream data = null;
	
	/**
	 * Set the game server.
	 * @param gs
	 */
	public void set( GameServer gs ) {
		this.gs = gs;
	}
	
	/**
	 * Runs this response.
	 */
	public abstract void run();

	/**
	 * Sets the output stream that this response will
	 * output to.
	 * 
	 * @param out valid output stream from client socket.
	 */
	public void setOutputStream( OutputStream out ) {
		data = new DataOutputStream( out );
	}
	
	/**
	 * Gets the data output stream for this response.
	 * @return valid dataoutputstream or null if error.
	 */
	public DataOutputStream getData() {
		return data;
	}

}
