package core.response;

import java.io.IOException;

import core.Constants;

/**
 * Sends a response changing the animation for a user.
 * @author eric
 *
 */
public class ResponseAnimation extends GameResponse {
	
	private long userId = -1;
	private long animationId = -1;
	
	public void setUserId( long userId ) {
		this.userId = userId;
	}
	
	public void setAnimationId( long animationId ) {
		this.animationId = animationId;
	}

	@Override
	public void run() {
		try {
			// Send animation response.
			getData().writeInt( Constants.RESP_ANIMATION );
			getData().writeLong( userId );
			getData().writeLong( animationId );
		} catch (IOException e) {
			gs.log( e.getMessage() );
		}

	}

}
