package core.response;

import java.io.IOException;

import core.User;

/**
 * Sends a chat response of the specified type.
 * @author eric
 */
public abstract class ResponseChat extends GameResponse {
	
	// The user who sent this message.
	private User user = null;
	
	// The string value of this message.
	private String message = null;
	
	// Response type set by c'tor.
	protected int responseType = -1;
	
	/**
	 * Sets the user who SENT the message.
	 * @param u User who sent the message.
	 */
	public void setUser( User u ) {
		user = u;
	}
	
	/**
	 * Sets the chat text.
	 * @param m text of chat.
	 */
	public void setMessage( String m ) {
		message = m;
	}

	@Override
	public void run() {
		try {
			// Send team chat message id
			getData().writeInt( responseType );
			getData().writeLong( user.getId() );
			getData().writeUTF( message );
		} catch ( IOException e ) {
			gs.log( e.getMessage() );
		}
	}

}
