package core.response;

import java.io.IOException;

import core.Constants;
import core.Team;
import core.User;

/**
 * Sends an update with the entire game status.  Similar to
 * response auth ok.
 * 
 * @author eric
 */
public class ResponseGlobalUpdate extends GameResponse {
	
	private User user;
	
	public void setUser( User u ) {
		user = u;
	}

	@Override
	public void run() {
		try {
			// Send auth_ok message id
			getData().writeInt( Constants.RESP_GLOBAL_UPDATE );
			
			// Info about all teams.
			getData().writeLong( gs.getTeamList().size() ); // # of teams
			for ( Team t : gs.getTeamList() ) {
				getData().writeLong( t.getId() ); // team id
				getData().writeUTF( t.getName() ); // team name
				getData().writeLong( t.getColor() ); // team color
			}
			
			// Send number of users, then data for each user.
			getData().writeLong( gs.getUserList().size() ); // # of users
			for ( User u : gs.getUserList() ) {
				getData().writeLong( u.getId() ); // user id
				getData().writeUTF( u.getName() );
				Team t = u.getTeam();
				getData().writeLong( t.getId() ); // team id
				getData().writeLong( u.getModelId() ); // model id
			}
			
			// Sector data.
			getData().writeLong( user.getSector().getId() ); // sector id
			getData().writeLong( user.getSector().getUserList().size() ); // number of users
			for ( User u : user.getSector().getUserList() ) {
				getData().writeLong( u.getId() ); // user id
				getData().writeLong( u.getLastMotionUpdateTime() ); // update time
				
				float[] transform =  u.getTransform();
				for( int i = 0; i < transform.length; i++ ) {
					getData().writeFloat( transform[i] );
					
				}
				
				getData().writeFloat( u.getForwardSpeed() );
				getData().writeFloat( u.getSidewaysSpeed() );
				getData().writeFloat( u.getXAxisAngularVelocity() );
				getData().writeFloat( u.getYAxisAngularVelocity() );
				getData().writeFloat( u.getZAxisAngularVelocity() );
			}
			
		} catch (IOException e) {
			gs.log( e.getMessage() );
		}

	}

}
