package core.response;

import java.io.IOException;

import core.Constants;
import core.User;

/**
 * Response sent to all other users informing them that
 * another user has connected.
 * @author eric
 *
 */
public class ResponseLogin extends GameResponse {
	
	private User user = null;
	
	public void setUser( User u ) {
		user = u;
	}

	@Override
	public void run() {
		gs.debug( "ResponseUpdateLogin" );
		try {
			getData().writeInt( Constants.RESP_LOGIN );
			
			// User info.
			getData().writeLong( user.getId() );
			getData().writeUTF( user.getName() );
			getData().writeLong( user.getTeam().getId() );
			getData().writeLong( user.getModelId() );
			getData().writeLong( user.getSector().getId() );
			
			// Output transform matrix.
			float[] transform = user.getTransform();
			for( int i = 0; i < transform.length; i++ ) {
				getData().writeFloat( transform[i] );
			}
			
			// Output velocities.
			getData().writeFloat( user.getForwardSpeed() );
			getData().writeFloat( user.getSidewaysSpeed() );
			
			// Angular velocities.
			getData().writeFloat( user.getXAxisAngularVelocity() );
			getData().writeFloat( user.getYAxisAngularVelocity() );
			getData().writeFloat( user.getZAxisAngularVelocity() );
			
		} catch (IOException e) {
			System.out.println("Error in ResponseLogin");
			e.printStackTrace();
		}

	}

}
