package core.response;

import java.io.IOException;

import core.Constants;
import core.User;

public class ResponseLogout extends GameResponse {
	
	private User user = null;
	
	public void setUser( User u ) {
		user = u;
	}

	@Override
	public void run() {
		try {
			getData().writeInt( Constants.RESP_LOGOUT );
			
			// Output userId
			getData().writeLong( user.getId() );
			
		} catch ( IOException e ) {
			gs.log( "Could not logout user: " + user.getId() );
			gs.log( e.getMessage() );
		}

	}

}
