package core.response;

import java.io.IOException;

import core.Constants;
import core.User;

public class ResponseMotion extends GameResponse {
	
	private User user = null;
	
	public void setUser( User u ) {
		user = u;
	}
	

	@Override
	public void run() {
		try {
			getData().writeInt( Constants.RESP_MOTION );
			
			// Output userId
			getData().writeLong( user.getId() );
			
			// Output transform matrix.
			float[] transform = user.getTransform();
			for( int i = 0; i < transform.length; i++ ) {
				getData().writeFloat( transform[i] );
			}
			
			// Output velocities.
			getData().writeFloat( user.getForwardSpeed() );
			getData().writeFloat( user.getSidewaysSpeed() );
			getData().writeFloat( user.getXAxisAngularVelocity() );
			getData().writeFloat( user.getYAxisAngularVelocity() );
			getData().writeFloat( user.getZAxisAngularVelocity() );
			
		} catch ( IOException e ) {
			gs.log("Error: In write output for user#" + user.getId() + " RequestMotion");
			e.printStackTrace();
		}
	}

}
