package spaceGame;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Vector;

import core.GameRequestTable;
import core.Sector;
import core.User;


public class SpaceGameServer extends core.GameServer {
	
	private GameDB db;
	
	// All logged-in users, maintained both in map and vector.
	private HashMap<Long, spaceGame.User> userMap = new HashMap<Long, spaceGame.User>();	
	private Vector<spaceGame.User> userList = new Vector<spaceGame.User>();
	

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		SpaceGameServer server = new SpaceGameServer();
		server.init();
		server.start();
	}
	
	@Override
	public void init() {
		// Call base class init.
		super.init();
		
		// Add to the GameRequestTable.
		try {
			GameRequestTable.add( Constants.REQ_QUIZ,          "spaceGame.request.RequestQuiz" );
			GameRequestTable.add( Constants.REQ_ANSWER_CHOICE, "spaceGame.request.RequestAnswerQuestionChoice" );
			GameRequestTable.add( Constants.REQ_NEXT_QUESTION, "spaceGame.request.RequestNextQuestion" );
			GameRequestTable.add( Constants.REQ_QUIZ_END,      "spaceGame.request.RequestQuizEnd" );
		} catch ( ClassNotFoundException e ) {
			log( e.getMessage() );
		}
	}
	
	@Override
	protected void createDB() throws SQLException {
		db = new GameDB( this );
	}
	
	public GameDB getDb() {
		return db;
		
	}

	@Override
	public int getNumThreads() {
		return 10;
	}

	@Override
	public int getPortNumber() {
		return 7654;
	}

	@Override
	public void signup(String username, String password) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void joinTeam(long userId, long teamId) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void leaveTeam(long userId, long teamId) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void spawnUser( core.User u ) {
		Sector s = null;
		long sectorId = -1;
		
		// For now, always span in sector id = -1.
		// TODO: more sectors.  I CAN GET M0ARS?
		if ( !sectors.containsKey( sectorId ) ) {
			s = new Sector();
			s.setId( sectorId );
			sectors.put( sectorId, s );
		} else {
			s = sectors.get( sectorId );
		}
		
		s.addUser( u );
		u.setSector( s );
		
	}
	
	public spaceGame.User getSpaceUser( long userId ) {
		return userMap.get( userId );
	}
	
	public User getUser( long userId ) {
		return userMap.get( userId );
	}
	
	
	/**
	 * Checks if a multiple choice question was correct.
	 * @param user
	 * @param choice
	 * @return
	 */
	public boolean checkQuizQuestionChoice( long quizQuestionId, char choice ) {
		return db.checkQuizQuestionChoice( quizQuestionId, choice );
	}
	
	/**
	 * Get the database object.
	 * @return
	 */
	public GameDB getSpaceDB() {
		return db;
	}

	public Vector<core.User> getUserList() {
		return new Vector<core.User>(userList);
	}
	
	/**
	 * Removes a user.
	 */
	public void removeUser( User u ) {
		userList.remove( u );
		userMap.remove( u );
	}

	@Override
	public long login( String username, String password ) {
		// Print message to console.
		log( "Connection attempt: " + username );
		
		// Validate username/password.
		spaceGame.User u = getDb().validateUser( username, password );
		if ( u == null ) {
			// Validation error.
			log( "Could not login user " + username );
			return -1;
		}
		
		// Add user to hashmap and list.
		userMap.put( u.getId(), u );
		userList.add( u );
		
		// Spawn the user to the appropriate Sector
		// and location.
		spawnUser( u );
				
		// Send response.
		return u.getId();
	}
	


}
