package spaceGame;

public class User extends core.User {
	
	// True if user is taking quiz.
	private boolean takingQuiz = false;
	
	// True if user is taking competition.
	private boolean takingCompetition = false;
	
	// True if user is taking exam.
	private boolean takingExam = false;
	
	// Last question ID (quiz, competition, or exam.)
	private long lastQuestionId;
	
	/**
	 * Starts a quiz.
	 * @param quizType type of quiz to start.
	 */
	public void startQuiz( long quizType ) {
		this.turnUpdatesOff();
		takingQuiz = true;
	}
	
	/**
	 * Stops the current quiz.
	 */
	public void stopQuiz() {
		takingQuiz = false;
	}
	
	/**
	 * True if the user is currently taking a quiz,
	 * else false.
	 * @return
	 */
	public boolean isTakingQuiz() {
		return takingQuiz;
	}
	
	/**
	 * Set the ID of the question.
	 * @param qid
	 */
	public void setLastQuestionId( long qid ) {
		lastQuestionId = qid;
	}
	
	/**
	 * Return ID of last question.
	 * @return
	 */
	public long getLastQuestionId() {
		return lastQuestionId;
	}

}
