package spaceGame.request;

import java.io.IOException;

import spaceGame.SpaceGameServer;
import spaceGame.User;
import spaceGame.response.ResponseAnswerCheck;

/**
 * Client answers a multiple choice question.
 * @author eric
 *
 */
public class RequestAnswerQuestionChoice extends GameRequest {
	
	// User ID.
	private long userId; 
	
	// User object.
	private User user;

	// The user's selection.
	private char choice;

	@Override
	public void parse() {
		try {
			userId = getData().readLong();
			choice = getData().readChar();
			getServer().debug( "RequestAnswerQuestionChoice got choice:" + choice );
		} catch ( IOException e ) {
			getServer().log( "RequestAnswerQuestionChoice.parse(): " + e.getMessage() );
		}
	}
	
	
	@Override
	public void run() {
		boolean correct = false;
		ResponseAnswerCheck check = new ResponseAnswerCheck();
		user = (spaceGame.User)gs.getUser( userId );
		if ( null == user ) {
			getServer().log( "RequestAnswerQuestionChoice: invalid user." );
			return;
		}
		
		// Check test type.
		if ( user.isTakingQuiz() ) {
			correct = getServer().getSpaceDB().checkQuizQuestionChoice( user.getLastQuestionId(), choice );
			this.getServer().debug("User is taking quiz:" + user.getLastQuestionId() + " " + choice );
		} else {
			// TODO: taking exam, competition.
		}
		
		// Make a note in the DB.
		((SpaceGameServer)gs).getDb().quizQuestionAnswered( userId, user.getLastQuestionId(), correct );
		
		// Finally, send a response to the user.
		try {
			check.set( getServer() );
			check.setCorrect( correct );
			check.setOutputStream( getSocket().getOutputStream() );
			check.run();
		} catch ( IOException e ) {
			getServer().log( "RequestAnswerQuestionChoice.run(): " + e.getMessage() );
		}
	}

}
