package spaceGame.request;

import java.io.IOException;

import spaceGame.User;
import spaceGame.response.ResponseQuestion;

/**
 * Requests the next question for the user's quiz, exam, or competition.
 * @author eric
 */
public class RequestNextQuestion extends GameRequest {

	// User ID.
	private long userId; 

	@Override
	public void parse() {
		try {
			userId = getData().readLong();
		} catch ( IOException e ) {
			getServer().log( "RequestNextQuestion.parse(): " + e.getMessage() );
		}

	}
	
	
	@Override
	public void run() {
		User user = (spaceGame.User)gs.getUser( userId );
		if ( null == user ) {
			getServer().log( "RequestNextQuestion.run(): invalid user." );
			return;
		}
		
		try {
			// Send response.
			ResponseQuestion response;
			if ( user.isTakingQuiz() ) {
				response = getServer().getSpaceDB().getQuizQuestionFor( user );
				response.set( getServer() );
				response.setOutputStream( getSocket().getOutputStream() );
				response.run();
			} else {
				// TODO: taking exam, competition.
			}
		
		} catch ( IOException e ) {
			getServer().log( "RequestNextQuestion.run(): " + e.getMessage() );
		}
	}
	

}
